-- NOTES:
-- local pOpts = GAMESTATE:GetPlayerState(pn):GetPlayerOptions("ModsLevel_Stage")
-- training:
-- pOpts:FailSetting("FailType_Off", true):Passmark(0, true):LifeSetting("LifeType_Bar")
-- default:
-- pOpts:FailSetting("FailType_EndOfSong", true):Passmark(0.7, true):LifeSetting("LifeType_Bar")
-- hard:
-- pOpts:FailSetting("FailType_Immediate", true):Passmark(0, true):LifeSetting("LifeType_Bar")
-- risky-4:
-- pOpts:FailSetting("FailType_Immediate", true):Passmark(0, true):LifeSetting("LifeType_Battery", true):BatteryLives(4)
-- risky-1:
-- pOpts:FailSetting("FailType_Immediate", true):Passmark(0, true):LifeSetting("LifeType_Battery", true):BatteryLives(1)

local pOptStrings = {
	["fallback"] = "faildefault,bar,no passmark,normal-drain",
	["default"] = "failatend,bar,70% passmark,normal-drain",
	["hard"] = "failimmediate,bar,no passmark,normal-drain",
	["training"] = "failoff,bar,no passmark,normal-drain",
	["pressure"] = "failimmediate,bar,no passmark,norecover",
	["risky-4"] = "failimmediate,battery,4 lives",
	["risky-1"] = "failimmediate,battery,1 life",
}

function LifeBarTypeIsChallenge(pn)
	return getenv("LifeBarType" .. ToEnumShortString(pn)) ~= "default"
end

function DefaultLifeBarTypeForCurGame()
	return GAMESTATE:GetCurrentGame():GetName() == "para" and "default" or "fallback"
end

function SetLifeBarTypeSettings(pn)
	local pOpts = GAMESTATE:GetPlayerState(pn):GetPlayerOptions("ModsLevel_Stage")
	local lifeType = getenv("LifeBarType" .. ToEnumShortString(pn))
	
	-- Don't use the "fallback" life settings for PARA mode.
	-- Also, failsafe.
	if (GAMESTATE:GetCurrentGame():GetName() == "para" and lifeType == "fallback") or not pOptStrings[lifeType] then
		setenv("LifeBarType" .. ToEnumShortString(pn), "default")
		lifeType = "default"
	end
	
	--pOpts:LifeSetting(string.find(lifeType, "risky") and "LifeType_Battery" or "LifeType_Bar")
	--GAMESTATE:GetPlayerState(pn):SetPlayerOptions( "ModsLevel_Stage", pOptStrings[lifeType])
	--GAMESTATE:ApplyStageModifiers(pn, pOptStrings[lifeType])
	-- gamecommand? really?...
	-- Unfortunately it was the most sticky/reliable way to apply these options
	GAMESTATE:ApplyGameCommand("mod," .. pOptStrings[lifeType], pn)
	
	-- just to be safe...
	MESSAGEMAN:Broadcast( "PlayerOptionsChanged", {PlayerNumber = pn} )
	MESSAGEMAN:Broadcast( "SongOptionsChanged" )
	--SM(GAMESTATE:GetDefaultSongOptions())
	Trace( "Options for life bar type '" .. lifeType .. "' set for " .. ToEnumShortString(pn) .. " (" .. pOptStrings[lifeType] .. ")" )
end

function ScreenSelectMusic:setupmusicstagemods()
	Trace( "setupmusicstagemods" )
	local pm = GAMESTATE:GetPlayMode()
	
	-- _fallback carryovers.
	if pm == "PlayMode_Battle" or pm == "PlayMode_Rave" then
		local so = GAMESTATE:GetDefaultSongOptions()
		GAMESTATE:SetSongOptions( "ModsLevel_Stage", so )
		MESSAGEMAN:Broadcast( "SongOptionsChanged" )
	elseif GAMESTATE:IsAnExtraStage() then
		if GAMESTATE:GetPreferredSongGroup() == "---Group All---" then
			local song = GAMESTATE:GetCurrentSong()
			GAMESTATE:SetPreferredSongGroup( song:GetGroupName() )
		end

		local bExtra2 = GAMESTATE:IsExtraStage2()
		local style = GAMESTATE:GetCurrentStyle()
		local song, steps = SONGMAN:GetExtraStageInfo( bExtra2, style )
		local po, so
		if bExtra2 then
			po = THEME:GetMetric("SongManager","OMESPlayerModifiers")
			so = THEME:GetMetric("SongManager","OMESStageModifiers")
		else
			po = THEME:GetMetric("SongManager","ExtraStagePlayerModifiers")
			so = THEME:GetMetric("SongManager","ExtraStageStageModifiers")
		end

		local difficulty = steps:GetDifficulty()
		local Reverse = PlayerNumber:Reverse()

		GAMESTATE:SetCurrentSong( song )
		GAMESTATE:SetPreferredSong( song )

		for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
			GAMESTATE:SetCurrentSteps( pn, steps )
			GAMESTATE:GetPlayerState(pn):SetPlayerOptions( "ModsLevel_Stage", po )
			GAMESTATE:SetPreferredDifficulty( pn, difficulty )
			MESSAGEMAN:Broadcast( "PlayerOptionsChanged", {PlayerNumber = pn} )
		end

		GAMESTATE:SetSongOptions( "ModsLevel_Stage", so )
		MESSAGEMAN:Broadcast( "SongOptionsChanged" )
	else
		-- new stuff to enforce life bar settings with.
		for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
			SetLifeBarTypeSettings(pn)
		end
		GAMESTATE:SetFailTypeExplicitlySet() -- just to be safe...
	end
	
	--SM(":D")
	
	return self
end

function ScreenSelectMusic:setupcoursestagemods()
	local mode = GAMESTATE:GetPlayMode()

	if mode == "PlayMode_Oni" then
		local po = "clearall,default"
		-- Let SSMusic set battery.
		-- local so = "failimmediate,battery"
		local so = "failimmediate"
		local Reverse = PlayerNumber:Reverse()

		for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
			GAMESTATE:GetPlayerState(pn):SetPlayerOptions( "ModsLevel_Stage", po )
			MESSAGEMAN:Broadcast( "PlayerOptionsChanged", {PlayerNumber = pn} )
		end

		GAMESTATE:SetSongOptions( "ModsLevel_Stage", so )
		MESSAGEMAN:Broadcast( "SongOptionsChanged" )
	end
	return self
end

-- (c) 2006-2007 Steve Checkoway
-- All rights reserved.
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a
-- copy of this software and associated documentation files (the
-- "Software"), to deal in the Software without restriction, including
-- without limitation the rights to use, copy, modify, merge, publish,
-- distribute, and/or sell copies of the Software, and to permit persons to
-- whom the Software is furnished to do so, provided that the above
-- copyright notice(s) and this permission notice appear in all copies of
-- the Software and that both the above copyright notice(s) and this
-- permission notice appear in supporting documentation.
-- 
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
-- OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
-- MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
-- THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
-- INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
-- OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
-- OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
-- OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
-- PERFORMANCE OF THIS SOFTWARE.

